-- QE test

GT = {};
dofile(current_mod_path..'/HMSQER08stovlTestRunwaysAndRoutes.lua')
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "HMS_LIZ"
GT.visual.shape_dstr = ""

GT.life = 7300; -- hit points
GT.mass = 7.2916e+007; -- Not sure what weight is used

GT.max_velocity = 15.433 -- Might be knots
GT.race_velocity = 15.433
GT.economy_velocity = 12.2889
GT.economy_distance = 13500
GT.race_distance = 2.778e+006

GT.shipLength = 226.9 --172.8
GT.Width = 80 --15
GT.Height = 35.226 --37.2 --44.4
GT.Length = 250 --172.8
GT.DeckLevel = 25.525

GT.X_nose = 122
GT.X_tail = -210
GT.Tail_Width = 18
--speed up, turning circle (speed) info
GT.Gamma_max = 0.35
GT.Om = 0.05;
GT.speedup = 0.119249;
GT.R_min = 665.8;

GT.RCS  = 70000

GT.distFindObstacles = 1048.9

GT.TACAN		   = true;		
GT.TACAN_position = {-7.006,  43.155,  -14.1}	

GT.numParking = 4
GT.Plane_Num_ = 35
GT.Helicopter_Num_ = 6

--GT.Landing_Point	= {7.0,	25.525, -40.49,} -- y z x 7.324, 11.812, -45.249

--
GT.LSOView = {cockpit = "empty", position = {--[[connector = "",]] offset = {13.0, 26.2, -17.9, -172.5, 4.0}}}
GT.OLS = {Type = GT_t.OLS_TYPE.Luna, MeatBallArg = 100}

--                               {int ArgumentNo, float OffValue, float OnValue, [float AnimationDuration],  [bool cycleAnimation]}
GT.carrierIlluminationStates = { 
								 {{69, 0.0, 1.0}, {307, 0.0, 0.45},{308, 0.0, 0.15}, {790, 0.0, 0.740}, {791, 0.0, 0.850}, {792, 0.0, 0.775}}, --NAV_LIGHTS
								 {{69, 0.0, 1.0}, {307, 0.0, 0.75}, {308, 0.0, 0.75}, {790, 0.0, 0.850}, {791, 0.0, 0.870}, {792, 0.0, 0.800}, {797, 1.0, 0.0}}, -- AC_LAUNCH_STATE
								 {{69, 0.0, 1.0}, {790, 0.0, 0.780}, {791, 1.0, 0.0}, {792, 0.0, 0.775}, {797, 0.0, 1.0}}, -- AC_RECOVERY_STATE
								}

--69 mast lights
--307 Traffic Lights
--790  Island Side Lights
--791  Island Spot Lights
--792  Deck Side Lights

--GT.animation_arguments.elevators = {57, 58};
--GT.animation_arguments.elevators_doors = {47, 48}; 
				 

GT.airWeaponDist = 5000
GT.airFindDist = 1000

--
GT.animation_arguments.radar2_rotation = 1; -- Radar 1 Rotation
GT.radar1_period = 0.5;

GT.animation_arguments.radar1_rotation = 2; -- Radar 2 Rotation
GT.radar1_period = 2;

GT.animation_arguments.radar3_rotation = 3; -- Radar 3 Rotation
GT.radar1_period = 0.5;

--


GT.DM = {
    { area_name = "NOSE_R_01", 				area_arg = 70, area_life = 150, area_fire = { connector = "FIRE_NOSE_R_01", size = 0.5}},
	{ area_name = "NOSE_R_02", 				area_arg = 94, area_life = 150, area_fire = { connector = "FIRE_NOSE_R_02", size = 0.5}},
	{ area_name = "CENTER_R_01", 			area_arg = 71, area_life = 150, area_fire = { connector = "FIRE_CENTER_R_01", size = 0.5}},
	{ area_name = "CENTER_R_02", 			area_arg = 96, area_life = 150, area_fire = { connector = "FIRE_CENTER_R_02", size = 0.5}},
    { area_name = "BACK_R", 				area_arg = 72, area_life = 300, area_fire = { connector = "FIRE_BACK_R", size = 0.5}},
	
    { area_name = "NOSE_L_01", 				area_arg = 73, area_life = 150, area_fire = { connector = "FIRE_NOSE_L_01", size = 0.5}},
	{ area_name = "NOSE_L_02", 				area_arg = 95, area_life = 150, area_fire = { connector = "FIRE_NOSE_L_02", size = 0.5}},
    { area_name = "CENTER_L_01", 			area_arg = 74, area_life = 150, area_fire = { connector = "FIRE_CENTER_L_01", size = 0.5}},
	{ area_name = "CENTER_L_02", 			area_arg = 97, area_life = 150, area_fire = { connector = "FIRE_CENTER_L_02", size = 0.5}},
	{ area_name = "CENTER_L_03", 			area_arg = 98, area_life = 150},
    { area_name = "BACK_L", 				area_arg = 75, area_life = 300, area_fire = { connector = "FIRE_BACK_L", size = 0.5}},
	
	{ area_name = "PALUBA_NOSE",			area_arg = 76, area_life = 100, area_fire = { connector = "FIRE_PALUBA_NOSE", size = 0.8}},
	{ area_name = "PALUBA_MIDLE_01",		area_arg = 77, area_life = 100, area_fire = { connector = "FIRE_PALUBA_MIDLE_01", size = 0.8}},
	{ area_name = "PALUBA_MIDLE_02",		area_arg = 92, area_life = 100, area_fire = { connector = "FIRE_PALUBA_MIDLE_02", size = 0.8}},
	{ area_name = "PALUBA_BACK_01", 		area_arg = 78, area_life = 100, area_fire = { connector = "FIRE_PALUBA_BACK_01", size = 0.8}},
	{ area_name = "PALUBA_BACK_02", 		area_arg = 93, area_life = 100, area_fire = { connector = "FIRE_PALUBA_BACK_02", size = 0.8}},
	
	{ area_name = "BACK", 					area_arg = 79, area_life = 100},
	{ area_name = "RUBKA",					area_arg = 80, area_life = 100, area_fire = { connector = "FIRE_RUBKA", size = 0.8}},
	{ area_name = "MACHTA",					area_arg = 81, area_life = 100},
	{ area_name = "TOWER",					area_arg = 82, area_life = 100},

	{ area_name = "ZA_NR",					area_arg = 99, area_life = 30},
	{ area_name = "ZA_BR",					area_arg = 100, area_life = 30},
	{ area_name = "ZA_BL",					area_arg = 101, area_life = 30},
	{ area_name = "NADSTROYKA_BR",			area_arg = 102, area_life = 30},
	{ area_name = "NADSTROYKA_BL",			area_arg = 103, area_life = 30},
	{ area_name = "ZRK_BR",					area_arg = 104, area_life = 30},
	{ area_name = "ZRK_NR",					area_arg = 105, area_life = 30},
	
	
	{ area_name = "LIFT_01",				area_arg = 109, area_life = 50},
	{ area_name = "LIFT_02",				area_arg = 110, area_life = 50},
	{ area_name = "LIFT_03",				area_arg = 111, area_life = 50},
	{ area_name = "LIFT_04",				area_arg = 112, area_life = 50},
}

GT.driverViewConnectorName = {"DRIVER_POINT", offset = {0.0, 0.0, 0.0}}
GT.driverCockpit = "DriverCockpit/DriverCockpitWithIR"
--Weapon Systems

GT.WS = {}
GT.WS.maxTargetDetectionRange = 30000;
GT.WS.radar_type = 104
GT.WS.searchRadarMaxElevation = math.rad(50);
--
--Port Stern

local ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].area = 'ZA_NR'
GT.WS[ws].angles = {
					 {math.rad(-110), math.rad(20), math.rad(-5), math.rad(70)}
				   }
GT.WS[ws].center = 'CENTER_TOWER_01'
GT.WS[ws].drawArgument1 = 21
GT.WS[ws].drawArgument2 = 22
GT.WS[ws].reference_angle_Y = math.rad(0)
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_01';
GT.WS[ws].LN[1].fireAnimationArgument = 121;
GT.WS[ws].LN[1].createMuzzleFlashEffect = true;
GT.WS[ws].LN[1].customViewPoint = { "IronSight/IronSight", {0.0, 0.0, 0.0} };
GT.WS[ws].pointer = "POINT_GUN_CAM_01"
--
--Port Bow

local ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].area = 'ZRK_NR'
GT.WS[ws].angles = {
					 {math.rad(120), math.rad(-10), math.rad(-5), math.rad(70)}
				   }
GT.WS[ws].center = 'CENTER_TOWER_03'
GT.WS[ws].drawArgument1 = 25
GT.WS[ws].drawArgument2 = 26
GT.WS[ws].reference_angle_Y = math.rad(0)
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_03';
GT.WS[ws].LN[1].fireAnimationArgument = 123;
GT.WS[ws].LN[1].createMuzzleFlashEffect = true;
GT.WS[ws].LN[1].customViewPoint = { "IronSight/IronSight", {0.0, 0.0, 0.0} };
GT.WS[ws].pointer = "POINT_GUN_CAM_03"



--Starboard Stern

local ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].area = 'ZA_BR'
GT.WS[ws].angles = {
					 {math.rad(-10), math.rad(130), math.rad(-5), math.rad(70)}
				   }
GT.WS[ws].center = 'CENTER_TOWER_04'
GT.WS[ws].drawArgument1 = 27
GT.WS[ws].drawArgument2 = 28
GT.WS[ws].reference_angle_Y = math.rad(0)
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_04';
GT.WS[ws].LN[1].fireAnimationArgument = 124;
GT.WS[ws].LN[1].createMuzzleFlashEffect = true;
GT.WS[ws].LN[1].customViewPoint = { "IronSight/IronSight", {0.0, 0.0, 0.0} };
GT.WS[ws].pointer = "POINT_GUN_CAM_04"




--Bow Starboard

local ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].area = 'ZRK_BR'
GT.WS[ws].angles = {
					 {math.rad(5), math.rad(-155), math.rad(-5), math.rad(70)}   --Left, Right_ Down, Up
				   }
GT.WS[ws].center = 'CENTER_TOWER_02'
GT.WS[ws].drawArgument1 = 23
GT.WS[ws].drawArgument2 = 24
GT.WS[ws].reference_angle_Y = math.rad(0)
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_02';
GT.WS[ws].LN[1].fireAnimationArgument = 122;
GT.WS[ws].LN[1].createMuzzleFlashEffect = true;
GT.WS[ws].LN[1].customViewPoint = { "IronSight/IronSight", {0.0, 0.0, 0.0} };
GT.WS[ws].pointer = "POINT_GUN_CAM_02"



GT.Name = "QE-S" -- folder in Liveries
GT.DisplayName = _("QE STOVL") --name in game
GT.Rate = 550.000000

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV"},
                RADAR = {
                    "seasparrow tr",
                    "carrier search radar",
                },
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange     = GT.airWeaponDist;
GT.Singleton       ="yes";
GT.mapclasskey     = "P0091000065";

GT.attribute		= {wsType_Navy, wsType_Ship, wsType_AirCarrier, WSTYPE_PLACEHOLDER,
						"Aircraft Carriers",
						"ski_jump",
						"Arresting Gear", "catapult",
						"RADAR_BAND1_FOR_ARM",
						"RADAR_BAND2_FOR_ARM",
						"DetectionByAWACS",
					};
GT.Categories		= {
						{name = "AircraftCarrier"},
						{name = "AircraftCarrier With Tramplin"},
						{name = "AircraftCarrier With Catapult"},
						{name = "Armed Ship"}
					};
				


add_surface_unit(GT)
